/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.updates;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.updates.AbstractUpdateableComponent;
import com.ibm.hwmca.fw.updates.AbstractUpdatesOwner;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.DependencyException;
import com.ibm.hwmca.xfw.updates.MissingDependencyException;
import com.ibm.hwmca.xfw.updates.Update;
import com.ibm.hwmca.xfw.updates.UpdateCollection;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.hwmca.xfw.updates.UpdateStyle;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class UpdateManager {
    private static final String TRACE_MASKT = "XCM XUMT";
    private static final String TRACE_MASKF = "XCM XUMF";
    private static UpdateManager updateManager = new UpdateManager();
    static /* synthetic */ Class class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner;

    public static UpdateManager getUpdateManager() {
        return updateManager;
    }

    private UpdateManager() {
    }

    public boolean isUpdatingFullyEnabled() {
        List components = this.getTowerUpdateableComponents();
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            if (component.isUpdatingEnabled()) continue;
            return false;
        }
        return true;
    }

    public boolean areAllRemoteSupportSystemsAvailable() {
        List components = this.getTowerUpdateableComponents();
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            if (component.isRemoteSupportSystemAvailable()) continue;
            return false;
        }
        return true;
    }

    public List getTowerUpdatesOwners() {
        List allOwners = this.getAllTowerUpdatesOwners();
        ArrayList xframeworkOwners = new ArrayList();
        Iterator iterator = allOwners.iterator();
        while (iterator.hasNext()) {
            Object owner = iterator.next();
            if (!(owner instanceof UpdatesOwner)) continue;
            xframeworkOwners.add(owner);
        }
        return xframeworkOwners;
    }

    public List getAllTowerUpdatesOwners() {
        Trace.trace(TRACE_MASKT, "-> getAllTowerUpdatesOwners()");
        ArrayList<AbstractUpdatesOwner> abstractUpdateableComponents = new ArrayList<AbstractUpdatesOwner>(5);
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        ClassId towerClass = new ClassId("com.ibm.hwmca.fw.managed.Tower");
        Iterator iterator = mom.getInventory(towerClass).iterator();
        while (iterator.hasNext()) {
            Tower tower = (Tower)iterator.next();
            AbstractUpdatesOwner updatesOwner = (AbstractUpdatesOwner)tower.getInterfaceImpl(class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner == null ? UpdateManager.class$("com.ibm.hwmca.fw.updates.AbstractUpdatesOwner") : class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner);
            if (updatesOwner == null) continue;
            abstractUpdateableComponents.add(updatesOwner);
        }
        Trace.trace(TRACE_MASKT, "<- getAllTowerUpdatesOwners() returning " + abstractUpdateableComponents.size() + " components.");
        return abstractUpdateableComponents;
    }

    public List getTowerUpdateableComponents() {
        List allComponents = this.getAllTowerUpdateableComponents();
        ArrayList xframeworkComponents = new ArrayList();
        Iterator iterator = allComponents.iterator();
        while (iterator.hasNext()) {
            Object component = iterator.next();
            if (!(component instanceof UpdateableComponent)) continue;
            xframeworkComponents.add(component);
        }
        return xframeworkComponents;
    }

    public List getAllTowerUpdateableComponents() {
        Trace.trace(TRACE_MASKT, "-> getAllTowerUpdateableComponents()");
        ArrayList abstractUpdateableComponents = new ArrayList();
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        ClassId towerClass = new ClassId("com.ibm.hwmca.fw.managed.Tower");
        Iterator iterator = mom.getInventory(towerClass).iterator();
        while (iterator.hasNext()) {
            Tower tower = (Tower)iterator.next();
            AbstractUpdatesOwner updatesOwner = (AbstractUpdatesOwner)tower.getInterfaceImpl(class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner == null ? UpdateManager.class$("com.ibm.hwmca.fw.updates.AbstractUpdatesOwner") : class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner);
            if (updatesOwner == null) continue;
            try {
                abstractUpdateableComponents.addAll(updatesOwner.getUpdateableComponents());
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKF, "Exception asking AbstractUpdatesOwner of tower " + tower.getName() + " for its updateable " + "components.  Skipping it.");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- getAllTowerUpdateableComponents() returning " + abstractUpdateableComponents.size() + " components.");
        return abstractUpdateableComponents;
    }

    public List getComponentsByOwner(AbstractUpdatesOwner updatesOwner) {
        List updateableComponents = null;
        if (updatesOwner == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            updateableComponents = updatesOwner.getUpdateableComponents();
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "Exception asking AbstractUpdatesOwner \"" + updatesOwner + "\" for its updateable components.");
            Trace.trace(TRACE_MASKF, e);
            return Collections.EMPTY_LIST;
        }
        Iterator iterator = updateableComponents.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof UpdateableComponent) continue;
            iterator.remove();
        }
        return updateableComponents;
    }

    public List getComponentsByTower(Tower tower) {
        return this.getComponentsByOwner((AbstractUpdatesOwner)tower.getInterfaceImpl(class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner == null ? (class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner = UpdateManager.class$("com.ibm.hwmca.fw.updates.AbstractUpdatesOwner")) : class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner));
    }

    public List getComponentsByManagedObject(ManagedObject managedObject) {
        return this.getComponentsByOwner((AbstractUpdatesOwner)managedObject.getInterfaceImpl(class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner == null ? (class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner = UpdateManager.class$("com.ibm.hwmca.fw.updates.AbstractUpdatesOwner")) : class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner));
    }

    public UpdatesOwner getOwnerForManagedObject(ManagedObject managedObject) {
        Object owner = managedObject.getInterfaceImpl(class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner == null ? (class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner = UpdateManager.class$("com.ibm.hwmca.fw.updates.AbstractUpdatesOwner")) : class$com$ibm$hwmca$fw$updates$AbstractUpdatesOwner);
        if (owner instanceof UpdatesOwner) {
            return (UpdatesOwner)owner;
        }
        return null;
    }

    public List getTowerUpdates() {
        ArrayList updates = new ArrayList();
        Iterator iterator = this.getTowerUpdateableComponents().iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            Iterator jiterator = component.getUpdateCollections().iterator();
            while (jiterator.hasNext()) {
                UpdateCollection collection = (UpdateCollection)jiterator.next();
                updates.addAll(collection.getUpdates());
            }
            updates.addAll(component.getUncollectedUpdates());
        }
        return updates;
    }

    public UpdateableComponent getComponentByName(String name) {
        List components = this.getTowerUpdateableComponents();
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public UpdateableComponent getComponentByECNumber(String ecNumber) {
        List components = this.getTowerUpdateableComponents();
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            if (!component.getECNumber().equals(ecNumber)) continue;
            return component;
        }
        return null;
    }

    public UpdateableComponent getComponentByECNumber(String ecNumber, UpdatesOwner updatesOwner) {
        List components;
        try {
            components = updatesOwner.getUpdateableComponents();
        }
        catch (HException e) {
            return null;
        }
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component;
            AbstractUpdateableComponent acomponent = (AbstractUpdateableComponent)iterator.next();
            if (!(acomponent instanceof UpdateableComponent) || !(component = (UpdateableComponent)acomponent).getECNumber().equals(ecNumber)) continue;
            return component;
        }
        return null;
    }

    public List getUpdateStylesUsed(List components) {
        ArrayList<UpdateStyle> uniqueStyles = new ArrayList<UpdateStyle>();
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            UpdateStyle style = component.getOwner().getUpdateStyle();
            if (uniqueStyles.contains(style)) continue;
            uniqueStyles.add(style);
        }
        return uniqueStyles;
    }

    public List getUpdateStylesUsedByUpdate(List updates) {
        ArrayList<UpdateStyle> uniqueStyles = new ArrayList<UpdateStyle>();
        Iterator iterator = updates.iterator();
        while (iterator.hasNext()) {
            Update update = (Update)iterator.next();
            UpdateStyle style = update.getUpdateableComponent().getOwner().getUpdateStyle();
            if (uniqueStyles.contains(style)) continue;
            uniqueStyles.add(style);
        }
        return uniqueStyles;
    }

    public List filterByUpdateStyle(List components, UpdateStyle style) {
        ArrayList<UpdateableComponent> filteredComponents = new ArrayList<UpdateableComponent>(components.size());
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            if (!component.getOwner().getUpdateStyle().equals(style)) continue;
            filteredComponents.add(component);
        }
        return filteredComponents;
    }

    public List arrangeDependenciesForApply(Collection updateCollections) throws MissingDependencyException, DependencyException {
        int[] legalStates = new int[]{1, 3};
        int[] legalDependencyStates = new int[]{5, 6};
        return this.arrangeDependencies(updateCollections, legalStates, legalDependencyStates, false);
    }

    private List arrangeDependencies(Collection updateCollections, int[] legalStates, int[] legalDependencyStates, final boolean reverse) throws MissingDependencyException, DependencyException {
        ArrayList<Dependency> candidates = new ArrayList<Dependency>(updateCollections.size());
        Iterator iterator = updateCollections.iterator();
        while (iterator.hasNext()) {
            UpdateLevel collection = (UpdateLevel)iterator.next();
            candidates.add(new Dependency(collection));
        }
        ArrayList<Dependency> resolved = new ArrayList<Dependency>(candidates.size());
        iterator = candidates.iterator();
        block8: while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            Trace.trace(TRACE_MASKF, "Examining implications of update level " + dependency);
            UpdateableComponent component = this.getComponentByECNumber(dependency.updateLevel.getUpdateableComponentECNumber());
            if (component == null) {
                throw new DependencyException("Unknown EC Number \"" + dependency.updateLevel.getUpdateableComponentECNumber() + "\" specified.");
            }
            int dependencyLevel = dependency.updateLevel.getLevel();
            List collections = component.getUpdateCollections();
            Collections.sort(collections, new Comparator(){

                public int compare(Object o1, Object o2) {
                    UpdateCollection c1 = (UpdateCollection)o1;
                    UpdateCollection c2 = (UpdateCollection)o2;
                    int result = c1.getId() - c2.getId();
                    return reverse ? -result : result;
                }
            });
            Iterator collIterator = collections.iterator();
            Dependency previousDependency = null;
            while (collIterator.hasNext()) {
                UpdateCollection collection = (UpdateCollection)collIterator.next();
                int collectionLevel = collection.getId();
                boolean addImplied = false;
                if (dependencyLevel == -1) {
                    addImplied = true;
                } else if (collectionLevel < dependencyLevel) {
                    if (reverse) continue block8;
                    addImplied = true;
                } else if (collectionLevel == dependencyLevel) {
                    dependency.collection = collection;
                    if (!resolved.contains(dependency)) {
                        resolved.add(dependency);
                        if (previousDependency != null) {
                            dependency.dependsOn(previousDependency);
                        }
                    }
                } else {
                    if (!reverse) continue block8;
                    addImplied = true;
                }
                if (!addImplied || !this.isLegalState(collection.getState(), legalStates)) continue;
                Dependency impliedDependency = new Dependency(collection);
                int knownIndex = resolved.indexOf(impliedDependency);
                if (knownIndex == -1) {
                    Trace.trace(TRACE_MASKF, "Adding implied collection " + impliedDependency);
                    resolved.add(impliedDependency);
                } else {
                    impliedDependency = (Dependency)resolved.get(knownIndex);
                    Trace.trace(TRACE_MASKF, "Referencing implied collection " + impliedDependency);
                }
                if (previousDependency != null) {
                    impliedDependency.dependsOn(previousDependency);
                }
                previousDependency = impliedDependency;
            }
        }
        candidates = null;
        HashMap reversePrerequisites = null;
        HashMap reverseHardPrerequisites = null;
        if (reverse) {
            reversePrerequisites = new HashMap();
            reverseHardPrerequisites = new HashMap();
            iterator = this.getTowerUpdateableComponents().iterator();
            while (iterator.hasNext()) {
                UpdateableComponent component = (UpdateableComponent)iterator.next();
                Iterator collIterator = component.getUpdateCollections().iterator();
                while (collIterator.hasNext()) {
                    Set<UpdateLevel> dependents;
                    Object dependency;
                    UpdateCollection collection = (UpdateCollection)collIterator.next();
                    Iterator reqIterator = collection.getPrerequisites().iterator();
                    while (reqIterator.hasNext()) {
                        dependency = reqIterator.next();
                        dependents = (HashSet<UpdateLevel>)reversePrerequisites.get(dependency);
                        if (dependents == null) {
                            dependents = new HashSet<UpdateLevel>();
                            reversePrerequisites.put(dependency, dependents);
                        }
                        dependents.add(new UpdateLevel(collection.getUpdateableComponent().getECNumber(), collection.getId()));
                    }
                    reqIterator = collection.getHardPrerequisites().iterator();
                    while (reqIterator.hasNext()) {
                        dependency = reqIterator.next();
                        dependents = (Set)reverseHardPrerequisites.get(dependency);
                        if (dependents == null) {
                            dependents = new HashSet();
                            reverseHardPrerequisites.put(dependency, dependents);
                        }
                        dependents.add(new UpdateLevel(collection.getUpdateableComponent().getECNumber(), collection.getId()));
                    }
                }
            }
        }
        String missingDepExceptionMsg = null;
        ArrayList<UpdateLevel> missingDependencies = null;
        iterator = resolved.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            Trace.trace(TRACE_MASKF, "Examining explicit dependencies of " + dependency);
            for (int reqType = 0; reqType <= 2; ++reqType) {
                Set requisites = null;
                switch (reqType) {
                    case 0: {
                        if (reverse) {
                            requisites = (Set)reversePrerequisites.get(dependency.getUpdateLevel());
                            if (requisites != null) break;
                            requisites = Collections.EMPTY_SET;
                            break;
                        }
                        requisites = dependency.collection.getPrerequisites();
                        break;
                    }
                    case 1: {
                        if (reverse) {
                            requisites = (Set)reverseHardPrerequisites.get(dependency.getUpdateLevel());
                            if (requisites != null) break;
                            requisites = Collections.EMPTY_SET;
                            break;
                        }
                        requisites = dependency.collection.getHardPrerequisites();
                        break;
                    }
                    case 2: {
                        requisites = dependency.collection.getCorequisites();
                    }
                }
                boolean committedIsLegal = this.isLegalState(6, legalDependencyStates);
                Iterator reqIterator = requisites.iterator();
                while (reqIterator.hasNext()) {
                    UpdateCollection collection;
                    UpdateLevel updateLevel = (UpdateLevel)reqIterator.next();
                    Trace.trace(TRACE_MASKF, "Considering its " + (reqType == 0 ? "prereq" : (reqType == 1 ? "hard prereq" : "coreq")) + " dependency on " + updateLevel);
                    try {
                        if (reqType != 2 && committedIsLegal) {
                            UpdateableComponent component = this.getComponentByECNumber(updateLevel.getUpdateableComponentECNumber());
                            if (component == null) {
                                throw new DependencyException("Unrecognized EC Number \"" + updateLevel.getUpdateableComponentECNumber() + "\"" + " specified as dependency.");
                            }
                            if (component.getCommittedLevel() >= updateLevel.getLevel()) {
                                Trace.trace(TRACE_MASKF, "Level is already committed");
                                continue;
                            }
                        }
                        collection = this.getUpdateCollectionFromLevel(updateLevel);
                    }
                    catch (DependencyException e) {
                        if (missingDepExceptionMsg == null) {
                            missingDepExceptionMsg = e.getMessage();
                            missingDependencies = new ArrayList<UpdateLevel>();
                        }
                        missingDependencies.add(updateLevel);
                        Trace.trace(TRACE_MASKF, "A dependency of EC " + dependency.toString() + " is missing.  Msg is: " + e.getMessage());
                        continue;
                    }
                    if (reqType != 2 && this.isLegalState(collection.getState(), legalDependencyStates)) {
                        Trace.trace(TRACE_MASKF, "Dependency is satisfied because it's already in an acceptable state");
                        continue;
                    }
                    Dependency lookupDependency = new Dependency(collection);
                    int locatedDependencyIndex = resolved.indexOf(lookupDependency);
                    if (locatedDependencyIndex == -1) {
                        String newMissingMsg = "EC " + dependency.toString() + " depends on EC " + lookupDependency.toString() + ", but that " + "EC was not specified or implied.";
                        if (missingDepExceptionMsg == null) {
                            missingDepExceptionMsg = newMissingMsg;
                            missingDependencies = new ArrayList();
                        }
                        missingDependencies.add(lookupDependency.getUpdateLevel());
                        Trace.trace(TRACE_MASKF, "Dependency is in wrong state.  Msg is: " + newMissingMsg);
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "Dependency is satisfied because it's specified (or implied) by this operation");
                    Dependency locatedDependency = (Dependency)resolved.get(locatedDependencyIndex);
                    dependency.dependsOn(locatedDependency, reqType);
                    if (reqType != 2) continue;
                    locatedDependency.dependsOn(dependency, 2);
                }
            }
        }
        if (missingDepExceptionMsg != null) {
            throw new MissingDependencyException(missingDepExceptionMsg, missingDependencies);
        }
        ArrayList allSteps = new ArrayList(3);
        ArrayList allEarlierDependencies = new ArrayList(resolved.size());
        while (!resolved.isEmpty()) {
            ArrayList currentStep = new ArrayList(resolved.size());
            Trace.trace(TRACE_MASKF, "Creating step " + allSteps.size());
            iterator = resolved.iterator();
            while (iterator.hasNext()) {
                Dependency entry = (Dependency)iterator.next();
                entry.decided = false;
            }
            int undecidedCount = resolved.size();
            while (undecidedCount > 0) {
                Dependency proposedAddition = null;
                iterator = resolved.iterator();
                while (iterator.hasNext()) {
                    proposedAddition = (Dependency)iterator.next();
                    if (proposedAddition.decided) continue;
                }
                Trace.trace(TRACE_MASKF, "Proposing to add " + proposedAddition);
                ArrayList<Dependency> draggedAdditions = new ArrayList<Dependency>(resolved.size());
                ArrayList parentsInSearch = new ArrayList(resolved.size());
                this.findDraggedDependencies(draggedAdditions, allEarlierDependencies, currentStep, proposedAddition, parentsInSearch);
                Trace.trace(TRACE_MASKF, "Adding it would drag in " + draggedAdditions.size() + " others");
                draggedAdditions.add(proposedAddition);
                boolean hardPrerequisiteViolation = false;
                Iterator draggedIterator = draggedAdditions.iterator();
                while (!hardPrerequisiteViolation && draggedIterator.hasNext()) {
                    Dependency addition = (Dependency)draggedIterator.next();
                    List dependencies = addition.getDependencies();
                    if (dependencies == null) continue;
                    Iterator depIterator = dependencies.iterator();
                    while (!hardPrerequisiteViolation && depIterator.hasNext()) {
                        DependencyLink link = (DependencyLink)depIterator.next();
                        if (link.type != 1 || allEarlierDependencies.contains(link.target)) continue;
                        Trace.trace(TRACE_MASKF, "Skipping since it would violate hard prereq by " + addition + " on " + link.target);
                        hardPrerequisiteViolation = true;
                    }
                }
                proposedAddition.decided = true;
                --undecidedCount;
                if (hardPrerequisiteViolation) continue;
                Trace.trace(TRACE_MASKF, "Selecting it for current step");
                iterator = draggedAdditions.iterator();
                while (iterator.hasNext()) {
                    Dependency dragged = (Dependency)iterator.next();
                    if (!dragged.decided) {
                        Trace.trace(TRACE_MASKF, "Also dragging in " + dragged);
                    }
                    dragged.decided = true;
                }
                undecidedCount -= draggedAdditions.size() - 1;
                currentStep.addAll(draggedAdditions);
                resolved.removeAll(draggedAdditions);
            }
            if (currentStep.isEmpty()) {
                StringBuffer msg = new StringBuffer();
                msg.append("Unresolvable hard prerequisite chain involving the following collections: ");
                iterator = resolved.iterator();
                while (iterator.hasNext()) {
                    msg.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    msg.append(", ");
                }
                throw new DependencyException(msg.toString());
            }
            allEarlierDependencies.addAll(currentStep);
            ArrayList<UpdateCollection> collectionsInCurrentStep = new ArrayList<UpdateCollection>(currentStep.size());
            iterator = currentStep.iterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                collectionsInCurrentStep.add(dependency.collection);
            }
            allSteps.add(collectionsInCurrentStep);
        }
        Trace.trace(TRACE_MASKF, "Final arrangeDependencies() results.  There are " + allSteps.size() + " steps:");
        Iterator stepIterator = allSteps.iterator();
        int i = 0;
        while (stepIterator.hasNext()) {
            Trace.trace(TRACE_MASKF, "Step " + i + ':');
            iterator = ((List)stepIterator.next()).iterator();
            while (iterator.hasNext()) {
                UpdateCollection collection = (UpdateCollection)iterator.next();
                Trace.trace(TRACE_MASKF, " Collection (" + collection.getUpdateableComponent().getECNumber() + ", " + collection.getId() + ")");
            }
            ++i;
        }
        return allSteps;
    }

    private boolean isLegalState(int state, int[] legalStates) {
        for (int i = 0; i < legalStates.length; ++i) {
            if (state != legalStates[i]) continue;
            return true;
        }
        return false;
    }

    private UpdateCollection getUpdateCollectionFromLevel(UpdateLevel level) throws DependencyException {
        UpdateableComponent component = this.getComponentByECNumber(level.getUpdateableComponentECNumber());
        if (component == null) {
            throw new DependencyException("Unrecognized EC Number \"" + level.getUpdateableComponentECNumber() + "\"" + " specified as dependency.");
        }
        int updateLevel = level.getLevel();
        Iterator iterator = component.getUpdateCollections().iterator();
        while (iterator.hasNext()) {
            UpdateCollection collection = (UpdateCollection)iterator.next();
            if (collection.getId() != updateLevel) continue;
            return collection;
        }
        throw new DependencyException("Unrecognized level " + updateLevel + " of EC Number \"" + level.getUpdateableComponentECNumber() + "\"" + " specified as dependency.");
    }

    private void findDraggedDependencies(List draggedAdditions, List allEarlierDependencies, List currentStep, Dependency proposedAddition, List parentsInSearch) throws DependencyException {
        List dependencies = proposedAddition.getDependencies();
        if (dependencies == null) {
            return;
        }
        parentsInSearch.add(proposedAddition);
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Dependency draggedDependency;
            DependencyLink link = (DependencyLink)iterator.next();
            if (link.type == 1 || allEarlierDependencies.contains(draggedDependency = link.target) || currentStep.contains(draggedDependency) || draggedAdditions.contains(draggedDependency)) continue;
            if (parentsInSearch.contains(draggedDependency)) {
                if (link.type == 2) continue;
                int parentsIndex = parentsInSearch.indexOf(draggedDependency);
                StringBuffer loopers = new StringBuffer();
                loopers.append("Loop detected in dependency list: ");
                int total = parentsInSearch.size();
                for (int i = parentsIndex; i < total; ++i) {
                    loopers.append(parentsInSearch.get(i));
                    loopers.append(" -> ");
                }
                loopers.append(parentsInSearch.get(parentsIndex));
                throw new DependencyException(loopers.toString());
            }
            this.findDraggedDependencies(draggedAdditions, allEarlierDependencies, currentStep, draggedDependency, parentsInSearch);
            draggedAdditions.add(draggedDependency);
        }
        parentsInSearch.remove(parentsInSearch.size() - 1);
    }

    public List arrangeDependenciesForReject(Collection updateCollections) throws MissingDependencyException, DependencyException {
        int[] legalStates = new int[]{5, 3};
        int[] legalDependencyStates = new int[]{1};
        return this.arrangeDependencies(updateCollections, legalStates, legalDependencyStates, true);
    }

    public List arrangeDependenciesForCommit(Collection updateCollections) throws MissingDependencyException, DependencyException {
        int[] legalStates = new int[]{5};
        int[] legalDependencyStates = new int[]{6};
        List steps = this.arrangeDependencies(updateCollections, legalStates, legalDependencyStates, false);
        if (steps.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return (List)steps.get(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DependencyLink {
        Dependency source;
        Dependency target;
        int type;

        public DependencyLink(Dependency source, Dependency target, int type) {
            this.source = source;
            this.target = target;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DependencyLink)) {
                return false;
            }
            DependencyLink other = (DependencyLink)o;
            return this.source.equals(other.source) && this.target.equals(other.target) && this.type == other.type;
        }
    }

    private static class Dependency {
        public static final int NORMAL = 0;
        public static final int HARD = 1;
        public static final int COREQ = 2;
        UpdateLevel updateLevel;
        UpdateCollection collection;
        List meOnThem;
        boolean decided;

        public Dependency(UpdateLevel updateLevel) {
            this.updateLevel = updateLevel;
        }

        public Dependency(UpdateCollection collection) {
            this.collection = collection;
        }

        public UpdateLevel getUpdateLevel() {
            if (this.updateLevel == null) {
                this.updateLevel = new UpdateLevel(this.collection.getUpdateableComponent().getECNumber(), this.collection.getId());
            }
            return this.updateLevel;
        }

        public void dependsOn(Dependency dependency) {
            this.dependsOn(dependency, 0);
        }

        public void dependsOn(Dependency dependency, int type) {
            DependencyLink link = new DependencyLink(this, dependency, type);
            if (this.meOnThem == null) {
                this.meOnThem = new ArrayList(2);
            }
            if (!this.meOnThem.contains(link)) {
                Trace.trace(UpdateManager.TRACE_MASKF, "Adding " + (type == 0 ? "prereq" : (type == 1 ? "hard" : "coreq")) + " dependency link for " + this + " on " + dependency);
                this.meOnThem.add(link);
            }
        }

        public List getDependencies() {
            return this.meOnThem;
        }

        public int hashCode() {
            if (this.updateLevel != null) {
                return this.updateLevel.hashCode();
            }
            if (this.collection != null) {
                return this.collection.getUpdateableComponent().getECNumber().hashCode() ^ this.collection.getId();
            }
            return super.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (this.updateLevel != null && other.updateLevel != null) {
                return this.updateLevel.equals(other.updateLevel);
            }
            if (this.collection != null && other.collection != null) {
                return this.collection.getUpdateableComponent().getECNumber().equals(other.collection.getUpdateableComponent().getECNumber()) && this.collection.getId() == other.collection.getId();
            }
            throw new IllegalStateException("Dependency objects not in same state");
        }

        public String toString() {
            if (this.updateLevel != null) {
                return "(" + this.updateLevel.getUpdateableComponentECNumber() + ", " + (this.updateLevel.getLevel() == -1 ? "ALL" : Integer.toString(this.updateLevel.getLevel())) + ")";
            }
            return "(" + this.collection.getUpdateableComponent().getECNumber() + ", " + this.collection.getId() + ")";
        }
    }
}

